package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Furrano_F_bumper extends Bumper
{
	public Furrano_F_bumper( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Furrano front bumper";

		value = 1240;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_04.Furrano:0x000000B6r, "L_headlights", actcolor, optical, power );
			addPart( cars.cat_04.Furrano:0x000000C6r, "R_headlights", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_04.Furrano:0x000000B6r, "L_headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.Furrano:0x000000C6r, "R_headlights", actcolor, optical, power );
		}
	}
}
